<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Info</title>
	
    <link href="<?php echo e(asset('backend')); ?>/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<button onclick="printStudent();" class="btn btn-primary"><i class="fa fa-print"> </i> Print Student Info</button>
<?php echo $__env->yieldContent('content'); ?>
<div style="background:white;padding:80px;margin-top:20;px" id="student_print_div">
<table>
  <tr>
    <td colspan="2">
      <img src="<?php echo e(get_logo()); ?>" style="width:300px;height: 300px;">
    </td>
    <td colspan="2">
      <h2><?php echo e(get_option('address')); ?></h2>
    </td>
    <td colspan="2">
		<img style="width:150px;height:150px;border: 2px solid grey;padding:10px;" src="<?php echo e(asset('uploads/images/'.$student->image)); ?>">
    </td>
  </tr>
</table> 
	<div class="row">
		<div class="col-md-12">
			<table class="table table-bordered" width="100%">
				<tbody>
					<tr>
						<td colspan="2"><?php echo e(_lang('Name')); ?></td>
						<td colspan="2"><?php echo e($student->first_name." ".$student->last_name); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Father Name')); ?></td>
						<td><?php echo e($student->father_name); ?></td>
						<td><?php echo e(_lang('Date Of Birth')); ?></td>
						<td><?php echo e($student->birthday); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Gender')); ?></td>
						<td><?php echo e($student->gender); ?></td>
						<td><?php echo e(_lang('Blood Group')); ?></td>
						<td><?php echo e($student->blood_group); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Floor')); ?></td>
						<td><?php echo e($student->class_name); ?></td>
						<td><?php echo e(_lang('Room')); ?></td>
						<td><?php echo e($student->section_name); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Religion')); ?></td>
						<td><?php echo e($student->religion); ?></td>
						<td>Address</td>
						<td><?php echo e($data['student']->address); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('Phone')); ?></td>
						<td><?php echo e($data['student']->phone); ?></td>
						<td><?php echo e(_lang('Email')); ?></td>
						<td><?php echo e($student->email); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('State')); ?></td>
						<td><?php echo e($student->state); ?></td>
						<td><?php echo e(_lang('Country')); ?></td>
						<td><?php echo e($student->country); ?></td>
					</tr>
					<tr>
						<td><?php echo e(_lang('CNIC')); ?></td>
						<td><?php echo e($student->activities); ?></td>
						<td><?php echo e(_lang('Remarks')); ?></td>
						<td><?php echo e($student->remarks); ?></td>
					</tr>
					<tr>
						<td colspan="4">I am Agreed on Monthly Rent</td>
							<table class="table">
								<thead>
									<th><?php echo e(_lang('Fee Type')); ?></th>
									<th style="text-align:left"><?php echo e(_lang('Amount')." ".get_option('currency_symbol')); ?></th>
									<th style="text-align:left"><?php echo e(_lang('Discount')." ".get_option('currency_symbol')); ?></th>
									<th style="text-align:left"><?php echo e(_lang('Total')." ".get_option('currency_symbol')); ?></th>		  
								</thead>
								<tbody id="invoice_assign">
									<?php if(count($data['assign_fees']) > 0): ?>
									<?php $__currentLoopData = $data['assign_fees']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td width="40%"><?php echo get_fee_selectbox('selection', $item->fee_id); ?></td>
										<td><input type="text" class="form-control" value="<?php echo e($item->amount); ?>" readonly></td>
										<td><input type="text" class="form-control" value="<?php echo e($item->discount); ?>" readonly></td>
										<td><input type="text" class="form-control" value="<?php echo e($item->amount - $item->discount); ?>" readonly></td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>
								</tbody>
								<tfoot>
								<tr>
									<td class="text-right" colspan="3"><label class="control-label"><?php echo e(_lang('Total')); ?></label></td>
									<td><input type="text" class="form-control" id="total_assign" name="total" value="<?php echo e($data['assign_fees']->sum('amount') - $data['assign_fees']->sum('discount')); ?>" readOnly="true"></td>
								</tr>
								</tfoot>
							</table>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>

	<div class="row" id="rules_and_regulations" style="font-size: 10px;">
		<div class="col-md-12">
		<p><b>Rules & Regulations: </b></p>
		<h4 style="text-align: justify;"><b>Note: I shall retain the hostel accommodation for the full academic session (i.e.__________/__________/202___-to-__________/__________/202___) and if I want to leave the hostel during the session (6 months/1 year), the hostel management is lawful not to refund my security deposit. Last date for fee submission is 5th of every month; late submission will be charged Rs. 100/= per day. If the late submission penalty is not paid with the fees, it will be adjusted from the deposited security amount respectively.</b></h4>
		<h6 style="text-align: justify;"><b>
			<ol>
				<li>I shall not be entitled to claim my admission in the hostel as a matter of right,</li>
				<li>I shalt not possess, use of deal with any kind of intoxicating material including alcohol, any kinds of drugs, gutka, tobacco cigarettes or any other such materials and on being found guilty, the management may take the disciplinary action (s) including restriction/force expulsion from hostel immediately without any prior notice.</li>
				<li>I shall not possess or used of any kind of weapon including sticks, rods, explosive, fireworks or any related object (s) /material and on being found guilty the management may take a disciplinary action (s) including restriction/ force expulsion from hostel immediately without any prior notice.</li>
				<li>I shall be solely/mutually (in case of room sharing) liable for any damage to the hostel property caused by my will or negligence and will be entitled to pay or else disciplinary actions will be taking accordingly.</li>
				<li>I solemnly affirm that I have not tendency and shall not make any attempt to commit. Suicide or beating or enticing any other person commit suicide or an thing unwarranted and or prohibited by the law or otherwise and shall not giving any sort of threats to commit suicide or likewise and being found guilty for the aforesaid action. I myself shall be responsible for any consequences, under law of land and expulsion/ rustication from the hostel and any other legal action under law of land Management will not be responsible for any of such action.</li>
				<li>I shall not keep any excess cash and valuable (Including smart phones, PCs, Laptop and etc.) within Hostel in case of any loss theft or damaged or any other personal belonging the management shall not be responsible of compensation.</li>
				<li>I fully understand that parking of vehicles (if allowed) is at on my own risk and in case of damaged or theft that management shall not be responsible of compensation.</li>
				<li>I shall not collect any money from any student, employees or other person in hostel premises for any purpose including donations, charity etc. Without written permission of hostel management.</li>
				<li>The management has the full authority for the inspections of the room (s), Bags, Cupboard or any of other belonging at any time (as and when deem ultimate requirement).</li>
				<li>I understand that the hostel allotted at the time of admission may be shifted to other branch at any time (if there is required for adjustment of seats).</li>
				<li>I shall not allow accompany any unauthorized person to enter or stay in room without prior permission however, night stay of friends is not allowed in any case.</li>
				<li>I shall not misuse electricity by using gadgets like iron, heaters, juicers etc. in case of caught for using these gadgets the management may impose penalty as per offense.</li>
				<li>All the type of charges and fees as charged by the management are subject to review at any time. However an annual escalation will be charged as per property law enforced in city.</li>
				<li>For any unforeseen issues arisen that is not covered by this undertaking or in respect of all the matters not expressly provided herein, the management may take any appropriate decision that shall be final and binding in me and all others concerned.</li>
				<li>I understand that the food will be served in time. Late comers will be entertained only if food is available after scheduled time.</li>
				<li>I am given this undertaking with full understanding and state that the information given above are true and complete to the best of my knowledge and belief and certificates documents and other information submitted by me are genuine and nothing has been concealed. I understand that any of statement made above is found incorrect. I shall liable to a disciplinary action(s) and penalty on me as decided by the management, notwithstanding legal action under the law of land .in such case, the hostel fee and other charges deposited by be shall be fortified.</li>
				<li>The management reserved the right to frame, amend, revoke or repeal the provisions including hostel timing that will be effective and binding in all the concerned by the management from time-to-time.</li>
				<li>The management reserves the rights to modify the rules and regulation as deem appropriate.</li>
			</ol></b>
		</p>
		</div>
	</div>
	
	<div class="row" id="footer" style="font-size: 10px;">
		<div class="col-md-12">
			<table class="" width="100%">
				<tbody>
					<tr>
						<td style="padding:20px;"><b><?php echo e(_lang('Place: ')); ?></b></td>
						<td style="padding:20px;"><?php echo e(get_option('address')); ?></td>
						<td style="padding:20px;"><b><?php echo e(_lang('(Signature)')); ?></b></td>
						<td style="padding:20px;">---------------------------------------------</td>
					</tr>
					<tr>
						<td colspan="1" style="padding:20px;"><b>Date: </b></td>
						<td colspan="3" style="padding:20px;"><?php echo e(date('Y-m-d')); ?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>
<script type="text/javascript" src="<?php echo e(asset('backend')); ?>/js/jquery.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('backend')); ?>/js/bootstrap.min.js"></script>

<script>

$(document).ready(function() {
	//restriction for the user select any other option
	$('.selection').css('pointer-events','none');
	printStudent();//print document on loading the page
});

//For print the page
function printStudent() {
    var content = $('#student_print_div').html();
    var rulesAndRegs = $('#rules_and_regulations').html(); // Get the rules and regulations content
    var footer = $('#footer').html(); // Get the rules and regulations content
    var newWindow = window.open('', '_blank');
    newWindow.document.write('<html><head><title>Student Info</title><link href="/backend/css/bootstrap.min.css" rel="stylesheet" /></head><body>');
    newWindow.document.write(content);
    newWindow.document.write('<div style="page-break-before: always;"></div>'); // Add a page break
    newWindow.document.write(rulesAndRegs); // Add rules and regulations content
    newWindow.document.write(footer); // Add footer
    newWindow.document.write('</body></html>');
    newWindow.document.close();
    newWindow.print();
}


</script>
</body>
</html><?php /**PATH /home/hostelmanager/public_html/test.hostelmanager.pk/resources/views/backend/students/student-print.blade.php ENDPATH**/ ?>